* This file contains the primary analysis of the ISSP macro data

*** Table 1: Cross-country well-being happiness link
* ssc install outreg2 
use "$directory/ISSP/ISSP_macro" if nonrepresentative==0, clear
for X in num 8 15 25: ///
	gen richX=(gdp>X000) if !missing(gdp) \ ///
	gen richX_lgdp=richX*(lgdp-ln(X000)) \ ///
	gen poorX_lgdp=(1-richX)*(lgdp-ln(X000)) 

reg lgdp lgdp
outreg2 using "$directory/ISSP/Table1_ISSP", replace ctitle("Ignore")

levelsof wave, local(waves)
foreach w of local waves {
	for X in num 8 15 25 :  ///
		reg hap_z richX_lgdp poorX_lgdp if wave==`w', robust \ ///
		lincom richX_lgdp-poorX_lgdp \ ///
		outreg2 using "$directory/ISSP/Table1_ISSP",  append ctitle(hap_z_`w'_Xk) addstat(Diff, r(estimate), SE, r(se), p_val, 2*(1-normal(abs(r(estimate)/r(se)))))
	
	summ lgdp if hap_z~=. & wave==`w', det
	gen top_lgdp=(lgdp>=r(p50))*(lgdp-r(p50))
	gen bottom_lgdp=(lgdp<r(p50))*(lgdp-r(p50))
	reg hap_z top_lgdp bottom_lgdp if wave==`w', robust
	lincom top_lgdp-bottom_lgdp	
	outreg2 using "$directory/ISSP/Table1_ISSP",  append ctitle(hap_z_`w'_>med) addstat(Diff, `r(estimate)', SE, `r(se)', p_val, 2*(1-normal(abs(`r(estimate)'/`r(se)'))))
	drop top_lgdp bottom_lgdp
}



* Appendix figure: Cross-national results
use "$directory/ISSP/ISSP_macro", clear
gen rich=(gdp>=15000) if gdp~=.
gen rich_lgdp=rich*(lgdp-ln(15000))
gen poor_lgdp=(1-rich)*(lgdp-ln(15000))
levelsof wave, local(waves)
local sd : char hap_z[sd]
local mean : char hap_z[mean]
di "`sd'"
local ylab ""

foreach i of num 2/4 {
	local yl=(`i'-`mean')/`sd'
	local ylab "`ylab' `yl' " `i' ""
}

foreach w of local waves {
	summ gdp if !missing(hap_z) & wave==`w'
	local gdpmin=r(min)
	local lb: label waves `w'
	reg hap_z lgdp if wave==`w' & nonrepresentative==0, robust
	predict hap_z_fit
	summ lgdp if wave==`w' & nonrepresentative==0 & hap_z~=., det
	gen top_lgdp=(lgdp>=r(p50))*(lgdp-r(p50))
	gen bottom_lgdp=(lgdp<r(p50))*(lgdp-r(p50))
	reg hap_z top_lgdp bottom_lgdp if wave==`w' & nonrepresentative==0, robust
	predict hap_z_fit2
	local b_top=string(_b[top_lgdp],"%3.2f")
	local se_top=string(_se[top_lgdp],"%3.2f")
	local b_bottom=string(_b[bottom_lgdp],"%3.2f")
	local se_bottom=string(_se[bottom_lgdp], "%3.2f")
	reg hap_z rich_lgdp poor_lgdp if wave==`w' & nonrepresentative==0, robust
	predict hap_z_fit3
	local b_rich=string(_b[rich_lgdp], "%3.2f")
	local se_rich=string(_se[rich_lgdp], "%3.2f")
	local b_poor=string(_b[poor_lgdp], "%3.2f")
	local se_poor=string(_se[poor_lgdp], "%3.2f")
	lowess hap_z lgdp if wave==`w' & nonrepresentative==0, nograph generate(hap_z_low)
	#delimit ;
	twoway
		(scatter hap_z gdp if nonrepresentative==0, mlabel(cty) mcolor(navy) mlabcolor(navy) yaxis(1 2))
		(scatter hap_z gdp if nonrepresentative>0, symbol(square_hollow) mlabel(cty) mcolor(gs12) mlabcolor(gs12)) 
		(line hap_z_low gdp if nonrepresentative==0, sort lpattern(dot) lcolor(cranberry) lwidth(medthick))
		(line hap_z_fit gdp if nonrepresentative==0, sort lpattern(solid) lcolor(black))
/*		(line hap_z_fit2 gdp if nonrepresentative==0, sort lpattern(shortdash) lcolor(purple) ) */
		(line hap_z_fit3 gdp if nonrepresentative==0, sort lpattern(longdash) lcolor(green) )
		if wave==`w' 
	,
		xscale(log)
		xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32" 64000 "64" 64000 "64") 
		xtitle("")
		ylabel(-1.5(.5)1.5, angle(horizontal) format(%9.1f) axis(2))
		ylabel(`ylab', angle(horizontal) format(%9.0f) axis(1))
		ytitle("")
		title("`lb'", ring(0) span)
		legend(off)
		text(-1.38 500 "GDP>$15k: Slope=`b_rich' (`se_rich')", justification(left) placement(3) margin(0) size(*.7) color(green))
		text(-1.50 500 "GDP<$15k: Slope=`b_poor' (`se_poor')", justification(left) placement(3) margin(0) size(*.7) color(green))
		xsize(10) ysize(7.5)
		name(Xcountry_hap_`w', replace)
	;
	#delimit cr		
	drop hap_z_fi* hap_z_low top_lgdp bottom_lgdp
}


#delimit ;
graph combine Xcountry_hap_1991 Xcountry_hap_1998 Xcountry_hap_2001 Xcountry_hap_2007 Xcountry_hap_2008,
	rows(2)
	imargin(none)
	l1title("Happiness (4 point scale)", size(small))
	r1title("Happiness (normalized)", size(small))
	b1title("Real GDP per Capita (thousands of dollars, log scale)", size(small))
	xsize(10) ysize(7.5)
	name(issp_hap_xs, replace)
;
#delimit cr
graph save "$directory\Charts\ISSP_hap_xs.gph", replace
for ! in any png eps emf : cap graph export "$directory\Charts\ISSP_hap_xs.!", replace



